@extends('layouts.admin.default')

@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-3 col-sm-12">
            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <div class="text-center">
                        <img class="profile-user-img img-fluid img-circle" src="{{ admin_avatar() }}" alt="User profile picture">
                    </div>

                    <h3 class="profile-username text-center">{{ auth()->user()->name }}</h3>

                    <p class="text-muted text-center">{{ auth()->user()->username }}</p>
                    <p class="text-muted text-center">{{ auth()->user()->email }}</p>

                    <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                            <b>Register</b> <a class="float-right">{{ auth()->user()->created_at }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>Last Update</b> <a class="float-right">{{ auth()->user()->updated_at }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>Email Verified</b> <a class="float-right">{!! auth()->user()->email_verified_at ? '<span class="badge badge-success">Yes</span>' : '<span class="badge badge-danger">No</span>' !!}</a>
                        </li>
                    </ul>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <div class="col-lg-9 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fa fa-user-edit"></i> Edit Profile</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="post" action="{{ route('admin.profile') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label for="name">Name</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ auth()->user()->name }}" placeholder="Enter name">
                                </div>
                                @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label for="username">Username</label>
                                    <input type="text" class="form-control @error('username') is-invalid @enderror" id="username" name="username" value="{{ auth()->user()->username }}" placeholder="Enter username">
                                </div>
                                @error('username')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label for="email">Email address</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" placeholder="Enter email">
                                </div>
                                @error('email')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label for="email_confirmation">Confirm Email</label>
                                    <input type="email" class="form-control" id="email_confirmation" name="email_confirmation" placeholder="Enter email">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label for="password">New Password</label>
                                    <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password" placeholder="Leave blank to do not change">
                                    <small class="form-text text-muted">Min 6 characters</small>
                                </div>
                                @error('password')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label for="password_confirmation">Confirm New Password</label>
                                    <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Leave blank to do not change">
                                    <small class="form-text text-muted">Min 6 characters</small>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="avatar">Avatar</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('avatar') is-invalid @enderror" id="avatar" name="avatar" accept="image/*">
                                    <label class="custom-file-label" for="avatar">Choose file</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">Formats: PNG|JPG. Max Size: 500KB</small>
                            @error('avatar')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <hr>
                        <h5>2FA Auth</h5>
                        <div class="form-group">
                            <label for="two_factor_method">Method</label>
                            <select id="two_factor_method" name="two_factor_method"
                                    class="form-control @error('two_factor_method')is-invalid @enderror">
                                <option
                                    value="none" {{auth()->user()->two_factor_method==='none'?'selected':''}}>None</option>
                                <option
                                    value="email" {{auth()->user()->two_factor_method==='email'?'selected':''}}>Email</option>
                                <option
                                    value="app" {{auth()->user()->two_factor_method==='app'?'selected':''}}>Authentication App</option>
                            </select>
                            @error('two_factor_method')
                            <div class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </div>
                            @enderror
                        </div>
                        @if(auth()->user()->two_factor_method==='app')
                            @if(!auth()->user()->google2fa_secret)
                                <h5>Setup Two Factor Authentication</h5>
                                <p>
                                    Set up your two factor authentication by scanning the barcode below. Alternatively, you can use the code <b>{{ $two_factor_secret }}</b>.
                                </p>
                                <div class="row mb-3">
                                    <div class="col-lg-6 col-sm-12">
                                        <img src="{{ $two_factor_qr_image }}">
                                    </div>
                                    <div class="col-lg-6 col-sm-12">
                                        <p>You can use one of the apps below.</p>
                                        <ul>
                                            <li>
                                                <a href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2"
                                                   target="_blank" title="Android">
                                                    <i class="fab fa-android"></i> Google Authenticator
                                                    (Android)
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://apps.apple.com/us/app/google-authenticator/id388497605"
                                                   target="_blank" title="iOS">
                                                    <i class="fab fa-app-store-ios"></i>
                                                    Google Authenticator (iOS)
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://play.google.com/store/apps/details?id=com.authy.authy"
                                                   target="_blank" title="Android">
                                                    <i class="fab fa-android"></i>
                                                    Authy (Android)
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://apps.apple.com/us/app/authy/id494168017"
                                                   target="_blank" title="iOS">
                                                    <i class="fab fa-app-store-ios"></i>
                                                    Authy (iOS)
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="alert alert-danger"><i
                                        class="fa fa-exclamation-triangle"></i>
                                    Save the code in a safe place, you may need it if you need to reinstall the app on your smartphone.
                                </div>
                                <div
                                    class="alert alert-info">Once you've set up your app with the generated code, click the save button to enable 2FA in your account.</div>
                                <input type="hidden" name="two_factor_secret" value="{{ $two_factor_secret }}">
                            @else
                                <div class="alert alert-warning"><i
                                        class="fa fa-exclamation-triangle"></i> Disabling or changing the authentication method will remove your current secret token!
                                </div>
                            @endif
                        @endif
                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
