@isset($plugin['wysiwyg'])
    @if(setting('default_editor') === 'summernote')
        @push('additional_styles')
            <!-- Summernote -->
            <link rel="stylesheet" href="{{ asset('assets/admin/plugins/summernote/summernote-bs4.min.css') }}">
        @endpush
        @push('additional_scripts')
            <!-- Summernote -->
            <script src="{{ asset('assets/admin/plugins/summernote/summernote-bs4.min.js') }}"></script>
            <script>
                //Summernote textarea
                $('.custom_wysiwyg').summernote({
                    height: 300,
                    toolbar: [
                        // [groupName, [list of button]]
                        ['paragraph', ['style']],
                        ['style', ['bold', 'italic', 'underline', 'clear']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['fontsize', ['fontsize']],
                        ['fontname', ['fontname']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['height', ['height']],
                        ['insert', ['table', 'hr', 'link']],
                        ['misc', ['codeview', 'undo', 'redo']]
                    ]
                });
            </script>
        @endpush
    @endif
    @if(setting('default_editor') === 'tinymce')
        @push('additional_scripts')
            <!-- TinyMCE -->
            <script src="{{ asset('assets/admin/plugins/tinymce/tinymce.min.js') }}"></script>
            <script>
                //TinyMCE textarea
                tinymce.init({
                    selector:'.custom_wysiwyg',
                    menubar: false,
                    plugins: [
                        'advlist autolink lists link image charmap print preview anchor',
                        'searchreplace visualblocks code',
                        'insertdatetime media table paste code help wordcount emoticons directionality hr'
                    ],
                    toolbar1: 'undo redo | fontselect | formatselect | ' +
                        ' bold italic underline forecolor backcolor | alignleft aligncenter ' +
                        ' alignright alignjustify ltr rtl',
                    toolbar2: 'bullist numlist outdent indent |' +
                        ' removeformat | link | emoticons | hr | table | image media | codesample | code help preview',
                });
            </script>
        @endpush
    @endif
@endisset
