@extends('layouts.admin.default')

@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Pages List</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.pages.create') }}" class="btn btn-sm btn-success @cannot('create-pages')disabled @endcannot"><i class="fa fa-plus-square"></i> Create</a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Name</th>
                                <th scope="col">Type</th>
                                <th scope="col">Status</th>
                                <th scope="col">Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($items as $item)
                                <tr>
                                    <th scope="row">{{ $item->id }}</th>
                                    <td>{{ $item->name }}</td>
                                    <td>
                                        @if($item->type === 'page')
                                            <span class="badge badge-success">Page</span>
                                        @elseif($item->type === 'tos')
                                            <span class="badge badge-danger">Tos</span>
                                        @else
                                            <span class="badge badge-warning">Privacy</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->status === 'published')
                                            <span class="badge badge-success">Published</span>
                                        @else
                                            <span class="badge badge-danger">Draft</span>
                                        @endif
                                    </td>
                                    <td>
                                        <form action="{{ route('admin.pages.destroy', $item->id) }}" method="post" onsubmit="return confirm('Are you sure you want to delete this record?')">
                                            @csrf
                                            @method('delete')
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('admin.pages.edit', $item->id) }}" class="btn btn-info @cannot('show-pages')disabled @endcannot"><i class="fa fa-edit"></i> Edit</a>
                                                <button type="submit" class="btn btn-danger" @cannot('delete-pages')disabled="disabled" @endcannot><i class="fa fa-trash"></i> Delete</button>
                                            </div>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">No results found!</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $items->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection
