@extends('layouts.admin.default')
@php $plugin['wysiwyg'] = true; @endphp
@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ $page_title }}</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <form action="{{ $form_params['action'] }}" method="post">
                        @csrf
                        @method($form_params['method'])
                        <div class="form-group">
                            <label for="title">Title</label>
                            <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ $item->title ?? old('title') }}" placeholder="Title">
                            @error('title')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select name="status" id="status" class="form-control @error('status') is-invalid @enderror">
                                <option value="">-- Select --</option>
                                <option value="published" @if(isset($item) && $item->status === 'published')selected @endif>Published</option>
                                <option value="draft" @if(isset($item) && $item->status === 'draft')selected @endif>Draft</option>
                            </select>
                            @error('status')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="content">Content</label>
                            <textarea class="form-control custom_wysiwyg @error('content') is-invalid @enderror" id="content" name="content" rows="15" placeholder="Content">{{ $item->content ?? old('content') }}</textarea>
                            @error('content')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-success" @cannot('edit-news')disabled="disabled" @endcannot><i class="fa fa-save"></i> {{ $form_params['button_name'] }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
