@extends('layouts.admin.default')

@section('content')
    @include('admin.partials.alerts')
    <!-- Small boxes (Stat box) -->
    <div class="row">
        <div class="col-lg-4 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>{{ $statistics->total_admins }}</h3>
                    <p>Total Admins</p>
                </div>
                <div class="icon">
                    <i class="fa fa-user-secret"></i>
                </div>
                <a href="{{ route('admin.admins.index') }}" class="small-box-footer">More info <i
                        class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-4 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>{{ $statistics->total_users }}</h3>
                    <p>Total Users</p>
                </div>
                <div class="icon">
                    <i class="fa fa-users"></i>
                </div>
                <a href="{{ route('admin.users.index') }}" class="small-box-footer">More info <i
                        class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-4 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-purple">
                <div class="inner">
                    <h3>{{ $statistics->total_pages }}</h3>
                    <p>Total Pages</p>
                </div>
                <div class="icon">
                    <i class="fa fa-file-word"></i>
                </div>
                <a href="{{ route('admin.pages.index') }}" class="small-box-footer">More info <i
                        class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-4 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-primary">
                <div class="inner">
                    <h3>{{ $statistics->unread_tickets }}</h3>
                    <p>Unread Messages</p>
                </div>
                <div class="icon">
                    <i class="fa fa-envelope"></i>
                </div>
                <a href="{{ route('admin.tickets.index') }}" class="small-box-footer">More info <i
                            class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-4 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3>{{ $statistics->total_news }}</h3>
                    <p>Total News</p>
                </div>
                <div class="icon">
                    <i class="fa fa-newspaper"></i>
                </div>
                <a href="{{ route('admin.news.index') }}" class="small-box-footer">More info <i
                            class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-4 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ $statistics->total_faqs }}</h3>
                    <p>Total F.A.Q.s</p>
                </div>
                <div class="icon">
                    <i class="fa fa-question-circle"></i>
                </div>
                <a href="{{ route('admin.faqs.index') }}" class="small-box-footer">More info <i
                            class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
    </div>
    <!-- /.row -->
    <h4>Deposits</h4>
    <div class="row">
        <div class="col-lg-6 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>{{ crypto_currency($statistics->paid_deposits) }}</h3>
                    <p>Total Deposits</p>
                </div>
                <div class="icon">
                    <i class="fa fa-university"></i>
                </div>
                <a href="{{ route('admin.deposits.index') }}" class="small-box-footer">More info <i
                            class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-6 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-secondary">
                <div class="inner">
                    <h3>{{ $statistics->pending_deposits }}</h3>
                    <p>Pending Deposits</p>
                </div>
                <div class="icon">
                    <i class="fa fa-hourglass"></i>
                </div>
                <a href="{{ route('admin.deposits.index') }}" class="small-box-footer">More info <i
                            class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
    </div>
    <!-- /.row -->
    <h4>Withdrawals</h4>
    <div class="row">
        <div class="col-lg-6 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>{{ crypto_currency($statistics->paid_withdrawals) }}</h3>
                    <p>Paid Withdrawals</p>
                </div>
                <div class="icon">
                    <i class="fa fa-money-bill"></i>
                </div>
                <a href="{{ route('admin.withdrawals.index') }}" class="small-box-footer">More info <i
                            class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-6 col-sm-12">
            <!-- small box -->
            <div class="small-box bg-secondary">
                <div class="inner">
                    <h3>{{ $statistics->pending_withdrawals }}</h3>
                    <p>Pending Withdrawals</p>
                </div>
                <div class="icon">
                    <i class="fa fa-hourglass"></i>
                </div>
                <a href="{{ route('admin.withdrawals.pending') }}" class="small-box-footer">More info <i
                            class="fas fa-arrow-circle-right"></i></a>
            </div>
        </div>
        <!-- ./col -->
    </div>
    <!-- /.row -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Script Details</h3>
                    <div class="card-tools">
                        @if(!session('scriptUpdate'))<a class="btn btn-sm btn-primary ml-5" href="{{route('admin.check_updates')}}"><i class="fa fa-sync"></i> Check Updates</a>@endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6 col-sm-12">
                            <dl class="row">
                                <dt class="col-sm-12 col-lg-6">Script Name</dt>
                                <dd class="col-sm-12 col-lg-6">{{ config('smartyscripts.script_name') }}</dd>
                                <dt class="col-sm-12 col-lg-6">Script Creator</dt>
                                <dd class="col-sm-12 col-lg-6">{{ config('smartyscripts.script_creator') }}</dd>
                            </dl>
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <dl class="row">
                                <dt class="col-sm-12 col-lg-6">Script Version</dt>
                                <dd class="col-sm-12 col-lg-6">{{ config('smartyscripts.script_version') }}</dd>
                                <dt class="col-sm-12 col-lg-6">Official Site</dt>
                                <dd class="col-sm-12 col-lg-6"><a href="{{ config('smartyscripts.script_creator_site') }}" target="_blank">{{ config('smartyscripts.script_creator_site') }}</a></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
