@extends('layouts.admin.default')
@php $plugin['wysiwyg'] = true; @endphp
@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ $page_title }}</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-sm-12 col-lg-3">Type</dt>
                        <dd class="col-sm-12 col-lg-9">{{ ucfirst($item->type) }}</dd>
                        <dt class="col-sm-12 col-lg-3">Message</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $item->message }}</dd>
                        <dt class="col-sm-12 col-lg-3">Date</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $item->created_at }}</dd>
                        @if($item->deposit_id)
                        <dt class="col-sm-12 col-lg-3">Deposit ID</dt>
                        <dd class="col-sm-12 col-lg-9"><a href="{{ route('admin.deposits.edit', $item->deposit_id) }}">#{{ $item->deposit_id }}</a></dd>
                        @endif
                        @if($item->withdrawal_id)
                        <dt class="col-sm-12 col-lg-3">Deposit ID</dt>
                        <dd class="col-sm-12 col-lg-9"><a href="{{ route('admin.withdrawals.edit', $item->withdrawal_id) }}">#{{ $item->withdrawal_id }}</a></dd>
                        @endif
                        @if($item->user_id)
                        <dt class="col-sm-12 col-lg-3">User ID</dt>
                        <dd class="col-sm-12 col-lg-9"><a href="{{ route('admin.users.edit', $item->user_id) }}">#{{ $item->user->wallet }}</a></dd>
                        @endif
                    </dl>
                    <div class="form-group">
                        <label for="response">API Response</label>
                        <textarea class="form-control" id="response" name="response" rows="15" readonly>{{ $item->response }}</textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
