@extends('layouts.admin.default')

@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Error Logs List</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Type</th>
                                <th scope="col">Message</th>
                                <th scope="col">Date</th>
                                <th scope="col">Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($items as $item)
                                <tr>
                                    <th scope="row">{{ $item->id }}</th>
                                    <td>
                                        @if($item->type === 'deposit')
                                            <span class="badge badge-success">{{ ucfirst($item->type) }}</span>
                                        @endif
                                        @if($item->type === 'withdrawal')
                                            <span class="badge badge-warning">{{ ucfirst($item->type) }}</span>
                                        @endif
                                        @if($item->type === 'others')
                                            <span class="badge badge-info">{{ ucfirst($item->type) }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $item->message }}</td>
                                    <td>{{ $item->created_at }}</td>
                                    <td>
                                        <form action="{{ route('admin.error_logs.destroy', $item->id) }}" method="post" onsubmit="return confirm('Are you sure you want to delete this record?')">
                                            @csrf
                                            @method('delete')
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('admin.error_logs.show', $item->id) }}" class="btn btn-info @cannot('show-error-logs')disabled @endcannot"><i class="fa fa-eye"></i> View</a>
                                                <button type="submit" class="btn btn-danger" @cannot('delete-error-logs')disabled="disabled" @endcannot><i class="fa fa-trash"></i> Delete</button>
                                            </div>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">No results found!</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $items->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection