@extends('layouts.admin.default')
@php $plugin['wysiwyg'] = true; @endphp
@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ $page_title }}</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-sm-12 col-lg-3">Invoice ID</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $item->invoice }}</dd>
                        <dt class="col-sm-12 col-lg-3">Expiration Date</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $item->invoice_expire_date }}</dd>
                        <dt class="col-sm-12 col-lg-3">User</dt>
                        <dd class="col-sm-12 col-lg-9"><a href="{{ route('admin.users.edit', $item->user_id) }}">#{{ $item->user->wallet }}</a></dd>
                    </dl>
                    <form action="{{ $form_params['action'] }}" method="post">
                        @csrf
                        @method($form_params['method'])
                        <div class="row">
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="power">Hashpower</label>
                                    <input type="number" class="form-control @error('power') is-invalid @enderror" id="power" name="power" value="{{ $item->power ?? old('power') }}" placeholder="Hashpower">
                                    @error('power')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="amount">Amount</label>
                                    <input type="number" step="0.00000001" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" value="{{ $item->amount ?? old('amount') }}" placeholder="Amount">
                                    @error('amount')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="paid_amount">Paid Amount</label>
                                    <input type="number" step="0.00000001" class="form-control @error('paid_amount') is-invalid @enderror" id="paid_amount" name="paid_amount" value="{{ $item->paid_amount ?? old('paid_amount') }}" placeholder="Paid Amount">
                                    @error('paid_amount')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="status">Status</label>
                                    <select name="status" id="status"
                                            class="form-control @error('status') is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        <option value="pending" @if($item->status === 'pending')selected @endif>Pending
                                        </option>
                                        <option value="processing" @if($item->status === 'processing')selected @endif>
                                            Processing
                                        </option>
                                        <option value="paid" @if($item->status === 'paid')selected @endif>
                                            Paid
                                        </option>
                                        <option value="canceled" @if($item->status === 'canceled')selected @endif>Canceled
                                        </option>
                                    </select>
                                    @error('status')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="cancel_reason">Cancel Reason</label>
                                    <input type="text"
                                           class="form-control @error('cancel_reason') is-invalid @enderror"
                                           id="cancel_reason" name="cancel_reason"
                                           value="{{ $item->cancel_reason ?? old('cancel_reason') }}"
                                           placeholder="Cancel Reason">
                                    <small class="form-text">Reason for the cancel. User can see this message.</small>
                                    @error('cancel_reason')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="tx_id">TX ID</label>
                                    <input type="text"
                                           class="form-control @error('tx_id') is-invalid @enderror"
                                           id="tx_id" name="tx_id"
                                           value="{{ $item->tx_id ?? old('tx_id') }}"
                                           placeholder="TX ID">
                                    <small class="form-text">Blockchain transaction ID.</small>
                                    @error('tx_id')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <h4>Additional Data</h4>
                        <div class="form-group">
                            <label for="response">Response</label>
                            <textarea name="response" id="response"
                                      class="form-control @error('response') is-invalid @enderror"
                                      rows="5">{{ $item->response ?? old('response') }}</textarea>
                            <small class="form-text">API response data.</small>
                            @error('response')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="comments">Admin Comments</label>
                            <textarea name="comments" id="comments"
                                      class="form-control @error('comments') is-invalid @enderror"
                                      rows="5">{{ $item->comments ?? old('comments') }}</textarea>
                            <small class="form-text">Comments about this user. Only admins can see comments.</small>
                            @error('comments')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-check mb-2">
                            <div class="checkbox">
                                <input type="checkbox" id="create_user_mining_plan" class="form-check-input" name="create_user_mining_plan">
                                <label for="create_user_mining_plan">Include this Mining Power to the user?</label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-success" @cannot('edit-deposits')disabled="disabled" @endcannot><i class="fa fa-save"></i> {{ $form_params['button_name'] }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
