@extends('layouts.admin.auth')
@push('page_class')login-page @endpush

@section('content')
    <div class="login-box">
        <div class="login-logo">
            <a href="{{ route('admin.index') }}"><b>{{ config('app.name') }}</b></a>
        </div>
        @include('admin.partials.alerts')
        <!-- /.login-logo -->
        <div class="card">
            <div class="card-body login-card-body">
                <p class="login-box-msg">{{ $message }}</p>

                <form action="{{route('admin.2fa')}}" method="post">
                    @csrf
                    <div class="input-group mb-3">
                        <input type="text" name="token" class="form-control @error('token')is-invalid @enderror"
                               placeholder="2FA Token">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>
                        @error('token')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                        @enderror
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary btn-block">Submit</button>
                        </div>
                        <!-- /.col -->
                    </div>
                </form>

                @if(auth('admin')->user()->two_factor_method === 'email')
                    <p class="mt-3 mb-1">
                        <a href="{{ route('admin.2fa.resend') }}">Resend Token</a>
                    </p>
                @endif
            </div>
            <!-- /.login-card-body -->
        </div>
    </div>
    <!-- /.login-box -->
@endsection
