<?php

namespace Database\Seeders;

use App\Models\TicketStatus;
use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon;

class TicketStatusSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        TicketStatus::create([
            'name' => 'Open',
            'css_class' => 'info',
            'default' => '1',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
        TicketStatus::create([
            'name' => 'Waiting',
            'css_class' => 'warning',
            'default' => '0',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
        TicketStatus::create([
            'name' => 'Closed',
            'css_class' => 'danger',
            'default' => '0',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
    }
}
