<?php

namespace Database\Seeders;

use App\Models\TicketPriority;
use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon;

class TicketPrioritySeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        TicketPriority::create([
            'name' => 'Low',
            'css_class' => 'info',
            'default' => '1',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
        TicketPriority::create([
            'name' => 'Medium',
            'css_class' => 'warning',
            'default' => '0',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
        TicketPriority::create([
            'name' => 'High',
            'css_class' => 'danger',
            'default' => '0',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
    }
}
