<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Setting;

class SettingSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Setting::set([
            //Seo
            'site_name' => config('app.name', 'CyberMiner'),
            //Design
            'admin_pagination' => 10,
            'site_pagination' => 10,
            'default_editor' => 'summernote',
            'default_alerts' => 'toastr',
            'frontend_theme' => 'default',
            'dashboard_theme' => 'default',
            'frontend_statistics' => '0',
            //Maintenance
            'maintenance_status' => 'inactive',
            //Cookies
            'cookie_consent_status' => 'no',
            //Configs
            'rates_api' => 'coingecko',
            'rates_api_crypto_currency' => 'litecoin',
            'rates_api_currency' => 'USD',
            'rates_api_interval' => '5',
            'reinvest_status' => 'disabled',
            'auto_suspend_users_interval' => '0',
            'signup_bonus' => '0',
            'referral_bonus' => '0',
            'purchase_min' => '1',
            'start_date' => date('Y-m-d H:i:s'),
            'blockchain_url' => 'https://chain.so/tx/LTC/',
            'hashpower_price' => '0.00000001',
            'daily_profit' => '0.00000001',
            'hashpower_unit' => 'GH',
            'period' => '1',
            'calculator_periods' => '1,3,5,7,8,30,90,365',
            'currency_name' => 'Litecoin',
            'currency_code' => 'LTC',
            'currency_decimals' => '2',
            'balance_decimals' => '15',
            'fiat_balance_decimals' => '5',
            'withdrawal_method' => 'manual',
            'withdrawal_deposit_required' => 'yes',
            'withdrawal_min' => '0.01000000',
            'withdrawal_max_auto' => '0.50000000',
            'withdrawal_max_daily' => '0',
            //Gateways
            'deposit_gateway' => 'coinpayments',
            'withdrawal_gateway' => 'coinpayments',
            'deposit_currency_code' => 'LTC',
            'withdrawal_currency_code' => 'LTC',
            'withdrawal_fee_fixed' => '0',
            'withdrawal_fee_percent' => '0',
            //General
            'force_https' => 'disabled',
            'multiple_accounts' => 'no',
        ]);
        Setting::save();
    }
}
