<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $roles = [
            'Super Admin',
            'Admin',
            'Demo',
        ];

        foreach ($roles as $role){
            Role::create(['name' => $role, 'guard_name' => 'admin']);
        }

        $permissions = Permission::pluck('id','id')->all();

        Role::find(1)->syncPermissions($permissions);
        Role::find(2)->syncPermissions(['9','10','11','12','13','19','20','21','22']);
        Role::find(3)->syncPermissions(['1','5','9','14','19','23']);
    }
}
