<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            'list-roles',
            'create-roles',
            'edit-roles',
            'delete-roles',
            'list-permissions',
            'create-permissions',
            'edit-permissions',
            'delete-permissions',
            'list-users',
            'create-users',
            'edit-users',
            'delete-users',
            'impersonate-users',
            'list-admins',
            'create-admins',
            'edit-admins',
            'delete-admins',
            'impersonate-admins',
            'list-pages',
            'create-pages',
            'edit-pages',
            'delete-pages',
            'list-settings',
            'edit-settings',
            'list-withdrawals',
            'edit-withdrawals',
            'delete-withdrawals',
            'pay-withdrawal-requests',
            'list-deposits',
            'edit-deposits',
            'delete-deposits',
            'list-news',
            'create-news',
            'edit-news',
            'delete-news',
            'list-faqs',
            'create-faqs',
            'edit-faqs',
            'delete-faqs',
            'list-ticket-status',
            'create-ticket-status',
            'edit-ticket-status',
            'delete-ticket-status',
            'list-ticket-priorities',
            'create-ticket-priorities',
            'edit-ticket-priorities',
            'delete-ticket-priorities',
            'list-ticket-categories',
            'create-ticket-categories',
            'edit-ticket-categories',
            'delete-ticket-categories',
            'list-tickets',
            'edit-tickets',
            'delete-tickets',
            'update-script',
            'show-roles',
            'show-permissions',
            'show-users',
            'show-admins',
            'show-pages',
            'show-settings',
            'show-withdrawals',
            'show-deposits',
            'show-news',
            'show-faqs',
            'show-ticket-status',
            'show-ticket-priorities',
            'show-ticket-categories',
            'show-tickets',
            'list-error-logs',
            'show-error-logs',
            'delete-error-logs',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission, 'guard_name' => 'admin']);
        }
    }
}








































































