<?php

namespace Database\Seeders;

use App\Models\Page;
use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon;

class PageSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Page::create([
            'name' => 'Terms of Service',
            'slug' => 'terms-of-service',
            'type' => 'tos',
            'status' => 'published',
            'content' => '<p>Terms of service page content here</p>',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
        Page::create([
            'name' => 'Privacy Policy',
            'slug' => 'privacy-policy',
            'type' => 'privacy',
            'status' => 'published',
            'content' => '<p>Privacy policy page content here</p>',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
    }
}
