<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Admin;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Carbon;

class AdminSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $user = Admin::create([
            'name' => 'Administrator',
            'email' => env('MAIL_FROM_ADDRESS', 'laraminlte@local'),
            'username' => 'admin',
            'password' => bcrypt('123456'),
            'email_verified_at' => Carbon::now(),
        ]);

        $role = Role::where('name', 'Super Admin')->find(1);

        $user->assignRole([$role->id]);
    }
}
