<?php
/**
 * AdminLTE General Settings
 **/

return [
    /**
     * Menu sections
     * slug: To identify section on Menu Links
     * name: Section name
     * permissions: permissions names (eg: ['list-admins','edit-admins'])
     */
    'site_menu_sections' => [
        ['slug' => 'main', 'name' => 'MAIN'],
        ['slug' => 'users', 'name' => 'MANAGE USERS', 'permissions' => ['list-users','list-admins']],
        ['slug' => 'finance', 'name' => 'FINANCES', 'permissions' => ['list-deposits', 'list-withdrawals']],
        ['slug' => 'content', 'name' => 'CONTENT', 'permissions' => ['list-pages', 'list-faqs']],
        ['slug' => 'support', 'name' => 'SUPPORT', 'permissions' => ['list-ticket-categories', 'list-ticket-status', 'list-ticket-priorities', 'list-tickets']],
        ['slug' => 'settings', 'name' => 'SETTINGS', 'permissions' => 'list-settings'],
    ],
    /**
     * Menu links
     * section: Section slug
     * name: Link name
     * icon: Font Awesome class name
     * route_type: route|url|external
     *   route: Route name
     *   url: External links or unnamed routes
     *   external: External links (target _blank)
     * target: Route name, external link/unnamed route
     * permissions: permissions names (eg: ['list-admins','edit-admins'])
     */
    'side_menu_items' => [
        //Main section
        [
            'section' => 'main', 'name' => 'Dashboard', 'icon' => 'fa-home', 'route_type' => 'route', 'target' => 'admin.index'
        ],
        //Users section
        [
            'section' => 'users', 'name' => 'Manage Users', 'icon' => 'fa-users', 'route_type' => 'route', 'target' => 'admin.users.index', 'permissions' => 'list-users',
        ],
        [
            'section' => 'users', 'name' => 'Manage Admins', 'icon' => 'fa-user-secret', 'route_type' => 'route', 'target' => 'admin.admins.index', 'permissions' => 'list-admins',
        ],
        [
            'section' => 'users', 'name' => 'Access Manager', 'icon' => 'fa-lock', 'route_type' => 'route', 'target' => '#', 'permissions' => ['list-roles', 'list-permissions'],
            //Child menu
            'child' => [
                ['name' => 'Roles', 'icon' => 'fa-briefcase', 'route_type' => 'route', 'target' => 'admin.roles.index', 'permissions' => 'list-roles'],
                ['name' => 'Permissions', 'icon' => 'fa-unlock', 'route_type' => 'route', 'target' => 'admin.permissions.index', 'permissions' => 'list-permissions'],
            ]
        ],
        //Finance section
        [
            'section' => 'finance', 'name' => 'Manage Deposits', 'icon' => 'fa-university', 'route_type' => 'route', 'target' => 'admin.deposits.index', 'permissions' => 'list-deposits',
        ],
        [
            'section' => 'finance', 'name' => 'Manage Withdrawals', 'icon' => 'fa-money-bill', 'route_type' => 'route', 'target' => 'admin.withdrawals.index', 'permissions' => 'list-withdrawals',
        ],
        [
            'section' => 'finance', 'name' => 'Withdrawal Requests', 'icon' => 'fa-hand-holding-usd', 'route_type' => 'route', 'target' => 'admin.withdrawals.pending', 'permissions' => 'list-withdrawals',
        ],
        //Content section
        [
            'section' => 'content', 'name' => 'Manage News', 'icon' => 'fa-newspaper', 'route_type' => 'route', 'target' => 'admin.news.index', 'permissions' => 'list-news',
        ],
        [
            'section' => 'content', 'name' => 'Manage Pages', 'icon' => 'fa-file', 'route_type' => 'route', 'target' => 'admin.pages.index', 'permissions' => 'list-pages',
        ],
        [
            'section' => 'content', 'name' => 'Manage F.A.Q.s', 'icon' => 'fa-question-circle', 'route_type' => 'route', 'target' => 'admin.faqs.index', 'permissions' => 'list-faqs',
        ],
        //Support section
        [
            'section' => 'support', 'name' => 'Tickets', 'icon' => 'fa-ticket-alt', 'route_type' => 'route', 'target' => 'admin.tickets.index', 'permissions' => 'list-tickets',
        ],
        [
            'section' => 'support', 'name' => 'Ticket Status', 'icon' => 'fa-spinner', 'route_type' => 'route', 'target' => 'admin.ticket_status.index', 'permissions' => 'list-ticket-status',
        ],
        [
            'section' => 'support', 'name' => 'Ticket Priorities', 'icon' => 'fa-tag', 'route_type' => 'route', 'target' => 'admin.ticket_priorities.index', 'permissions' => 'list-ticket-priorities',
        ],
        [
            'section' => 'support', 'name' => 'Ticket Categories', 'icon' => 'fa-tags', 'route_type' => 'route', 'target' => 'admin.ticket_categories.index', 'permissions' => 'list-ticket-categories',
        ],
        //Settings section
        [
            'section' => 'settings', 'name' => 'Error Logs', 'icon' => 'fa-exclamation-triangle', 'route_type' => 'route', 'target' => 'admin.error_logs.index', 'permissions' => 'list-error-logs',
        ],
        [
            'section' => 'settings', 'name' => 'Settings', 'icon' => 'fa-cog', 'route_type' => 'route', 'target' => 'admin.settings', 'permissions' => 'list-settings',
        ],
        [
            'section' => 'settings', 'name' => 'Update Script', 'icon' => 'fa-sync', 'route_type' => 'route', 'target' => 'admin.update_script', 'permissions' => 'list-settings',
        ],
    ]
];
