<?php

namespace App\Libraries;

class SendBitApi {

    private $api_key, $api_secret, $method, $fields;

    public function __construct($api_key, $api_secret) {
        $this->api_key = $api_key;
        $this->api_secret = $api_secret;
        $this->setField('api_key', $api_key);
        $this->setField('api_secret', $api_secret);
    }

    public function setCoin($coin) {
        $this->setField('coin', strtoupper($coin));
    }

    public function setMethod($method) {
        $this->method = $method;
        $this->setField('method', $method);
    }

    public function setField($field, $value) {
        $this->fields[$field] = $value;
    }

    public function process() {

        $url = "https://sendbit.io/api/" . $this->method;
        $fields_string = '';

        foreach ($this->fields as $key => $value) {
            $fields_string .= $key . '=' . $value . '&';
        }

        rtrim($fields_string, '&');

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POST, count($this->fields));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        $result = curl_exec($ch);
        curl_close($ch);

        return json_decode($result, true);

    }

    public function validatePayment($hash, $auth_hmac) {

        $generated_hmac = hash_hmac('sha512', $hash, $this->api_secret);

        if (hash_equals($generated_hmac, $auth_hmac)) {
            return true;
        }

        return false;

    }

}