<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TicketRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'category_id' => 'required|integer|exists:ticket_categories,id',
            'priority_id' => 'required|integer|exists:ticket_priorities,id',
            'status_id' => 'required|integer|exists:ticket_statuses,id',
            'admin_read' => 'required|boolean',
        ];
    }
}
