<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Auth;
use App\Notifications\TwoFactor;

class TwoFactorAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if(Auth::check())
        {
            $user = auth('admin')->user();
            $two_factor_expiry = session()->get('two_factor_expiry');
            $two_factor_google2fa = session()->get('google2fa');

            //2FA EMAIL
            if($user->two_factor_method === 'email'){
                if(!isset($two_factor_expiry)){
                    $user->two_factor_token = \Str::random(16);
                    $user->save();
                    $user->notify(new TwoFactor($user->two_factor_token));
                    return redirect(route('admin.2fa'));
                }
                return $next($request);
            }

            //2FA APP
            if($user->two_factor_method === 'app'){
                if(!$two_factor_google2fa && isset($user->google2fa_secret)){
                    return redirect(route('admin.2fa'));
                }
                return $next($request);
            }

            //Disabled 2FA
            return $next($request);
        }
    }
}
