<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Traits\PurchaseTrait;

class PurchaseController extends Controller
{
    use PurchaseTrait;

    public function index($invoice)
    {
        $deposit = Deposit::whereInvoice($invoice)->whereUserId(auth()->user()->id)->whereStatus('pending')->firstOrFail();

        $now = \Carbon\Carbon::now();
        if(isset($deposit->invoice_expire_date) && $now->greaterThanOrEqualTo($deposit->invoice_expire_date)){
            $deposit->update(['status' => 'canceled']);
            return redirect()->route('my-deposits')->withError('The payment term has expired. Make a new deposit.');
        }

        // If response is null or empty, try to create the payment address again
        if(empty($deposit->response)){
            $payment = $this->createDepositAddress($deposit);
            if($payment){
                if(filter_var($payment, FILTER_VALIDATE_URL)){
                    return redirect($payment);
                }
                // Refresh the deposit to get updated response
                $deposit->refresh();
            } else {
                return redirect()->route('my-deposits')->withError('Failed to create payment address. Please try creating a new deposit.');
            }
        }

        $invoice_params = json_decode($deposit->response);
        
        // Additional check: if invoice_params is null or doesn't have result property, try to regenerate
        if(!$invoice_params || (!isset($invoice_params->result) && setting('deposit_gateway') === 'coinpayments' && setting('coinpayments_mode') !== 'gateway')){
            $payment = $this->createDepositAddress($deposit);
            if($payment){
                if(filter_var($payment, FILTER_VALIDATE_URL)){
                    return redirect($payment);
                }
                $deposit->refresh();
                $invoice_params = json_decode($deposit->response);
            }
        }

        return view('dashboard::payments.invoice')->with([ 
            'invoice' => $deposit, 
            'invoice_params' => $invoice_params
        ]);
    }
}
