<?php

if (!function_exists('adminlte_sidebar_menu')) {
    /**
     * @param $section_name string
     * @return string|null
     */
    function adminlte_classes($section_name)
    {
        $section = array();
        //Navbar
        $section['navbar'] = config('adminlte_settings.navbar_color');

        if (in_array(config('adminlte_settings.navbar_color'), ['navbar-light', 'navbar-warning', 'navbar-white', 'navbar-orange'])) {
            $section['navbar'] .= config('adminlte_settings.navbar_color') !== 'navbar-light' ? ' navbar-light' : '';
        } else {
            $section['navbar'] .= ' navbar-dark';
        }
        if (config('adminlte_settings.navbar_border_bottom')) {
            $section['navbar'] .= ' ' . config('adminlte_settings.navbar_border_bottom');
        }
        if (config('adminlte_settings.navbar_text_size')) {
            $section['navbar'] .= ' ' . config('adminlte_settings.navbar_text_size');
        }
        //Body
        $section['body'] = '';
        if(config('adminlte_settings.body_text_size')) {
            $section['body'] .= ' '.config('adminlte_settings.body_text_size');
        }
        if(config('adminlte_settings.body_accent_colors')) {
            $section['body'] .= ' '.config('adminlte_settings.body_accent_colors');
        }
        if(config('adminlte_settings.default_layout')) {
            $section['body'] .= ' '.config('adminlte_settings.default_layout');
        }
        if(config('adminlte_settings.body_color_mode')) {
            $section['body'] .= ' '.config('adminlte_settings.body_color_mode');
        }
        //Dark/light mode
        $display_mode = isset($_COOKIE['display_mode']) && $_COOKIE['display_mode'] == 'dark' ? 'dark-mode' : '';
        $section['body_color_mode'] = ' '. $display_mode ?? config('adminlte_settings.body_color_mode');
        //Sidebar
        $section['sidebar'] = config('adminlte_settings.sidebar_color');
        if(config('adminlte_settings.sidebar_expand_on_focus_and_hover')) {
            $section['sidebar'] .= ' '.config('adminlte_settings.sidebar_expand_on_focus_and_hover');
        }
        //Sidebar nav
        $section['sidebar_nav'] = '';
        if(config('adminlte_settings.sidebar_nav_text_size')) {
            $section['sidebar_nav'] .= ' '.config('adminlte_settings.sidebar_nav_text_size');
        }
        if(config('adminlte_settings.sidebar_nav_flat_style')) {
            $section['sidebar_nav'] .= ' '.config('adminlte_settings.sidebar_nav_flat_style');
        }
        if(config('adminlte_settings.sidebar_nav_legacy_style')) {
            $section['sidebar_nav'] .= ' '.config('adminlte_settings.sidebar_nav_legacy_style');
        }
        if(config('adminlte_settings.sidebar_nav_compact_style')) {
            $section['sidebar_nav'] .= ' '.config('adminlte_settings.sidebar_nav_compact_style');
        }
        if(config('adminlte_settings.sidebar_nav_child_indent')) {
            $section['sidebar_nav'] .= ' '.config('adminlte_settings.sidebar_nav_child_indent');
        }
        //Brand
        $section['brand'] = config('adminlte_settings.brand_color');
        if(config('adminlte_settings.brand_text_size')) {
            $section['brand'] .= ' '.config('adminlte_settings.brand_text_size');
        }

        return $section[$section_name] ?? null;
    }
}

if (!function_exists('adminlte_sidebar_menu')) {
    /**
     * Generate side menu list
     * @return string
     */
    function adminlte_sidebar_menu()
    {
        $sections = config('adminlte_menus.site_menu_sections');
        $links = config('adminlte_menus.side_menu_items');

        foreach ($sections as $section) {
            if(isset($section['permissions']) && !auth()->user()->canAny($section['permissions'])){ continue; }
            echo '<li class="nav-header">' . $section['name'] . '</li>';
            $section_links = array_filter($links, function ($link) use ($section) {
                if ($link['section'] === $section['slug']) {
                    return $link;
                }
            });
            echo adminlte_section_links($section_links);
        }
    }
}

if (!function_exists('adminlte_section_links')) {
    /**
     * Generate side menu links
     * @param array $links
     * @return string
     */
    function adminlte_section_links($links)
    {
        $menu_links = '';
        $target = '';
        foreach ($links as $link) {
            if($link['route_type'] === 'route'){
                $link_url = ($link['target'] !== '#') ? route($link['target']) : '#';
            }
            if($link['route_type'] === 'url'){
                $link_url = ($link['target'] !== '#') ? url($link['target']) : '#';
            }
            if($link['route_type'] === 'external'){
                $link_url = ($link['target'] !== '#') ? url($link['target']) : '#';
                $target = 'target="_blank" rel="noreferrer"';
            }
            $child_links = adminlte_section_child_links($link);
            $show_arrow = isset($link['child']) ? '<i class="right fas fa-angle-left"></i>' : '';
            if(isset($link['permissions']) && !auth()->user()->canAny($link['permissions'])){ continue; }
            $menu_links .= '
            <li class="nav-item">
                <a href="' . $link_url . '" class="nav-link" '.$target.'>
                    <i class="nav-icon fas ' . $link['icon'] . '"></i>
                    <p>' . $link['name'] . '</p>' . $show_arrow . '
                </a>' . $child_links . '
            </li>
            ';
        }
        return $menu_links;
    }
}

if (!function_exists('adminlte_section_child_links')) {
    /**
     * Generate child links for side menu links
     * @param array $child_items
     * @return string
     */
    function adminlte_section_child_links($child_items)
    {
        $child_links = '';
        $target = '';
        if (isset($child_items['child']) && is_array($child_items['child'])) {
            $child_links = '
                        <ul class="nav nav-treeview">';
            foreach ($child_items['child'] as $link) {
                if($link['route_type'] === 'route'){
                    $link_url = ($link['target'] !== '#') ? route($link['target']) : '#';
                }
                if($link['route_type'] === 'url'){
                    $link_url = ($link['target'] !== '#') ? url($link['target']) : '#';
                }
                if($link['route_type'] === 'external'){
                    $link_url = ($link['target'] !== '#') ? url($link['target']) : '#';
                    $target = 'target="_blank" rel="noreferrer"';
                }
                $child_links .= '
                            <li class="nav-item">
                                <a href="' . $link_url . '" class="nav-link" '.$target.'>
                                    <i class="nav-icon fas ' . $link['icon'] . '"></i>
                                    <p>' . $link['name'] . '</p>
                                </a>
                            </li>';
            }
            $child_links .= '
                        </ul>';
        }
        return $child_links;
    }
}

if(!function_exists('admin_avatar')){
    function admin_avatar(){
        $avatar = 'assets/admin/dist/img/user2-160x160.jpg';
        if(isset(auth()->user()->avatar)){
            $avatar_path = 'assets/admin/dist/avatar/';
            $avatar = $avatar_path.auth()->user()->avatar;
        }
        return asset($avatar);
    }
}
