<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;

class SuspendInactiveUsers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'suspend-inactive-users';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Suspend inactive accounts that have not made deposits';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $timer = setting('auto_suspend_users_interval');

        if ($timer) {
            $users = User::where('allow_withdrawal', '0')->whereStatus('active')->get();

            if ($users) {
                foreach ($users as $user) {
                    if ($user->created_at->addHours($timer)->lessThanOrEqualTo(now())) {
                        $this->info('#' . $user->id . ' deactivated.');
                        $user->update(['status' => 'inactive']);
                    }
                }
            }
        }
    }
}
