<?php

namespace App\Console\Commands;

use App\Models\Withdrawal;
use Illuminate\Console\Command;
use App\Traits\WithdrawalTrait;

class ProcessWithdrawal extends Command
{
    use WithdrawalTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'process-withdrawals';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $withdrawal_mode = setting('withdrawal_method');
        $max_withdrawal_amount = setting('withdrawal_max_auto');

        if($withdrawal_mode === 'cron'){
            $this->info('Starting Processing Withdrawal Requests');
            //Get withdrawal requests
            $withdrawals = Withdrawal::whereStatus('pending')->where('amount', '<=', $max_withdrawal_amount)->oldest()->limit(10)->get();

            if($withdrawals->count() > 0){
                foreach($withdrawals as $withdrawal){
                    $this->info('Processing Withdrawal Request #'.$withdrawal->id);
                    $result = $this->autoWithdrawal($withdrawal);
                    if(in_array('success', $result)){
                        $this->info('Withdrawal Request #'.$withdrawal->id. ' completed.');
                    }else{
                        $this->info('Error processing withdrawal request #'.$withdrawal->id. '. Message: '.$result['error']);
                    }
                }
            }
            $this->info('Withdrawal Request Processing Completed');
        }
    }
}
