$(document).ready(function () {
    //Active menu
    const url = window.location + '';
    const pathname = window.location.pathname;
    const home_url = url.split('/', 3)[2];
    const admin = url.split('/')[3];
    const base = url.split('/', 2)[0] + '//' + home_url + '/' + admin;
    const active_url = pathname.split('/')[2];
    const sidebar = $('.nav-sidebar');
    const active_link = active_url ? sidebar.find('a[href="' + base + '/' + active_url + '"]') : sidebar.find('a[href="' + base + '"]');
    const parent = active_link.parent().parent();
    active_link.addClass('active');
    if (parent.hasClass('nav-treeview')) {
        parent.prev().addClass('active');
        parent.parent().addClass('menu-open');
    }
});

function setCookie(cname, cvalue, exdays) {
    let d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    let expires = "expires="+d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
    let name = cname + "=";
    let ca = document.cookie.split(';');
    for(let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}
/*
Dark Mode
 */
let display_cookie = getCookie('display_mode') ? getCookie('display_mode') : setCookie('display_mode', 'light', 365);
const display_mode = document.getElementById('display-mode');
const display_mode_icon = display_mode.querySelector('i');
if(display_cookie === 'dark'){
    display_mode_icon.classList.remove('fa-sun');
    display_mode_icon.classList.add('fa-moon');
    document.body.classList.add('dark-mode');
}

function toggleDisplayMode(){
    if(display_cookie === 'light'){
        document.body.classList.toggle('dark-mode');
        setCookie('display_mode', 'dark', 365);
        display_mode_icon.classList.toggle('fa-sun');
        display_mode_icon.classList.toggle('fa-moon');
        display_cookie = 'dark';
    }else{
        document.body.classList.toggle('dark-mode');
        setCookie('display_mode', 'light', 365);
        display_mode_icon.classList.toggle('fa-moon');
        display_mode_icon.classList.toggle('fa-sun');
        display_cookie = 'light';
    }
}
